% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_df.R
\name{compare_df}
\alias{compare_df}
\alias{compare_df,data.frame,data.frame,character-method}
\alias{compare_df,lib_df,lib_df,missing-method}
\title{Compare data frames and libraries}
\usage{
compare_df(x, y, key, ...)

\S4method{compare_df}{data.frame,data.frame,character}(x, y, key, ...)

\S4method{compare_df}{lib_df,lib_df,missing}(x, y, key, ...)
}
\arguments{
\item{x}{The (old) reference data frame.}

\item{y}{The updated (new) data frame.}

\item{key}{A character value with the name of the variable used as primary
key in the tables.}

\item{...}{Further arguments passed among methods.}
}
\value{
A S3 object of class \linkS4class{comp_df}, which can be printed in the console by
\code{\link[=print]{print()}}.
}
\description{
Report on differences between two versions of the same data frame or
electronic library.
When used for data frames, you need to indicate the variable containing IDs
for each entry, while applied to \linkS4class{lib_df} objects, the variable
'bibtexkey' will be considered as ID per default.

The output printed in the console will advice about added and deleted entries
in 'y' as well as any change in the entries common to both versions.
}
\examples{
# Partially matching libraries
Refs1 <- synopsis[1:10, ]
Refs2 <- synopsis[6:15, ]

# some modification in second library
Refs2[3, "title"] <- "New Title"

# compare libraries
compare_df(Refs1, Refs2)
}
\seealso{
\code{\link[=update]{update()}}, \linkS4class{lib_df}, \linkS4class{comp_df}
}
