% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{cba}
\alias{cba}
\title{Calculate Cronbach's Alpha reliability-coefficient from supplied variables.}
\usage{
cba(x)
}
\arguments{
\item{x}{A data-frame or matrix of numerical values where rows represent respondents, and columns represent items.}
}
\value{
Cronbach's Alpha for the sum-score of supplied variables.
}
\description{
Calculates Cronbach's Alpha reliability coefficient of the sum-score.
}
\note{
Missing values are treated by passing \code{na.rm = TRUE} to the \code{var} function call.

Be aware that this function does not issue a warning if there are negative correlations between variables in the supplied data-set.
}
\examples{
# Generate some fictional data. Say 100 students take a 50-item long test
# where all items are equally difficult.
set.seed(1234)
p.success <- rBeta.4P(100, 0.25, 0.75, 5, 3)
for (i in 1:50) {
  if (i == 1) {
    rawdata <- matrix(nrow = 100, ncol = 50)
  }
  rawdata[, i] <- rbinom(100, 1, p.success)
}
# To calculate Cronbach's Alpha for this test:
cba(rawdata)
}
\references{
Cronbach, L.J. (1951). Coefficient alpha and the internal structure of tests. Psychometrika 16, 297--334. doi: 10.1007/BF02310555
}
