% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{rygg}
\alias{rygg}
\title{Rygg's Index of Diversity}
\usage{
rygg(taxon, count, adjusted = FALSE)
}
\arguments{
\item{taxon}{taxa names (\code{character})}

\item{count}{counts (\code{numeric})}

\item{adjusted}{(defaults to \code{FALSE})}
}
\value{
Rygg's index of diversity (\code{numeric} \code{vector} of length 1)
}
\description{
Rygg's index of diversity is given by
\deqn{SN = \frac{\ln(S)}{\ln(\ln(N))}}{SN = ln(S)/(ln(ln(N)))}
}
\details{
The adjusted version of Rygg's index which gives more consistent values
for smaller \code{S=2, N=2, N=3} and \code{S=3, N=3} is
\deqn{SN = \frac{\ln(S)}{\ln(\ln(N+1)+1)}}{SN = ln(S)/(ln(ln(N+1)+1))}
}
\note{
Rygg's index is not defined for \eqn{N=exp(1)}. For
     \eqn{N \leq exp(1)}{N <= exp(1)}, \code{rygg} returns
     \code{\link{NA_real_}}.
}
\examples{
 rygg(
     taxon = c("Euspira pulchella", "Nephtys cirrosa"),
     count = c(4, 6)
 )

}
\references{
Rygg, B. (2006). Developing indices for quality-status
     classification of marine soft-bottom fauna in Norway.
     Norwegian Institute for Water Research, Oslo, Norway.
     NIVA Report SNO 5208-2006.
}
