% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mig_adjust.R
\name{mig.median.set}
\alias{mig.median.set}
\alias{mig.median.shift}
\alias{mig.median.reset}
\alias{mig.align.predictions}
\alias{mig.shift.prediction.to.wpp}
\title{Adjusting the Projection Medians}
\usage{
mig.median.set(sim.dir, country, values, years = NULL, ...)

mig.median.shift(
  sim.dir,
  country,
  reset = FALSE,
  shift = 0,
  from = NULL,
  to = NULL
)

mig.median.reset(sim.dir, countries = NULL)

mig.align.predictions(
  sim.dir1,
  sim.dir2,
  country.codes = NULL,
  years = NULL,
  ...
)

mig.shift.prediction.to.wpp(sim.dir, ...)
}
\arguments{
\item{sim.dir}{Directory containing the prediction object.}

\item{country}{Name or numerical code of a country.}

\item{values}{Vector of the new median values.}

\item{years}{Numeric vector giving years for which to change the median. 
In \code{mig.median.set} it gives years which \code{values} correspond to.
Ideally it should be of the same length as \code{values}. If it is \code{NULL}, 
\code{values} are set starting from the first prediction time period. 
If \code{values} correspond to consecutive years, only the first year might be given here.
In \code{mig.align.predictions} it gives years for which the medians should be aligned.}

\item{\dots}{Additional arguments passed to the underlying adjustment functions, such as 
\code{verbose} to show/hide the progress of the adjustment.
For \code{mig.shift.prediction.to.wpp} it can be \code{stat} with values \dQuote{median} (default) 
or \dQuote{mean} to specify which statistics should be adjusted; 
\code{wpp.year} to adjust it to if it differs from the wpp year of the simulation.}

\item{reset}{Logical. If \code{TRUE} medians in a range of \code{from} and \code{to} are
reset to their original values.}

\item{shift}{Constant by which the medians should be offset. It is not used if \code{reset} is \code{TRUE}.}

\item{from}{Year from which the offset/reset should start. By default, it starts at the first prediction period.}

\item{to}{Year until which the offset/reset should be done. By default, it is set to the last prediction period.}

\item{countries}{Vector of country names or codes. If this argument is \code{NULL} (default), 
the reset is done for all countries.}

\item{sim.dir1}{Directory with the bayesMig prediction object to be adjusted.}

\item{sim.dir2}{Directory with the bayesMig prediction object used to align the medians from \code{sim.dir1} to.}

\item{country.codes}{Numerical codes of countries to adjust. By default all countries 
found in \code{sim.dir2} are adjusted in \code{sim.dir1}.}
}
\value{
All functions return an updated object of class \code{\link{bayesMig.prediction}}.
}
\description{
These functions are to be used by expert analysts. They allow to 
    change the projection medians either to specific values, or shift the medians 
    by a given constant or align one projection object with another.
}
\details{
The function \code{mig.median.set} can be used to set the medians of the
    given country to specific values.

Function \code{mig.median.shift} can be used to offset the medians by a specific constant, or to reset
    the medians to their original values.

Function \code{mig.median.reset} resets medians of the given countries
    to the original values. By default it deletes adjustments for all countries.

Function \code{mig.align.predictions} shifts medians stored in \code{sim.dir1} to match 
    the medians in \code{sim.dir1}.
    
    In all cases, if a median is modified, the corresponding offset is stored in the prediction object 
    (element \code{median.shift}). All functions write the updated prediction object back to disk. All
    functions in the package that use trajectories and trajectory statistics use the \code{median.shift} 
    values to offset the results correspondingly, i.e. trajectories are shifted the same way as the
    medians.

Function \code{mig.shift.prediction.to.wpp} shifts the projected medians or means 
    (if \code{stat} is \dQuote{mean}), so that they correspond to the values found in the \code{migproj1dt} or \code{migproj5dt}
    datasets of the \pkg{wpp} package that either corresponds to the package used for the simulation itself 
    or is given by the \code{wpp.year} argument. Currently, the function only works for \pkg{wpp2024}.
    Note that regardless if it is an adjustment of the median or mean, the corresponding offset is always 
    converted to a shift of the median.
}
