% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_uncertainty.R
\name{fit_by_horizon}
\alias{fit_by_horizon}
\title{Helper function that fits its each column of the matrix (horizon) to an
observation model.}
\usage{
fit_by_horizon(obs, pred, fit_model = fit_nb)
}
\arguments{
\item{obs}{Matrix or vector of observations.}

\item{pred}{Matrix or vector of predictions.}

\item{fit_model}{Function that ingests observations and expectations
and returns uncertainty parameters, default is \code{fit_nb}.}
}
\value{
Vector of uncertainty parameters of the same length as the number
of columns in the \code{obs} matrix.
}
\description{
Helper function that fits its each column of the matrix (horizon) to an
observation model.
}
\examples{
obs <- matrix(
  c(
    5, 6, 2,
    1, 4, 2,
    8, 4, 2
  ),
  nrow = 3,
  byrow = TRUE
)
pred <- matrix(
  c(
    4.2, 5.2, 1.8,
    0.7, 3.5, 3.4,
    7.3, 4.1, 1.2
  ),
  nrow = 3,
  byrow = TRUE
)
disp <- fit_by_horizon(obs = obs, pred = pred)
disp
}
\seealso{
Observation error estimation functions
\code{\link{estimate_uncertainty}()},
\code{\link{fit_nb}()}
}
\concept{estimate_observation_error}
