% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default-credential.R
\name{get_token_provider}
\alias{get_token_provider}
\title{Get Default Token Provider Function}
\usage{
get_token_provider(
  scope = NULL,
  tenant_id = NULL,
  client_id = NULL,
  client_secret = NULL,
  use_cache = "disk",
  offline = TRUE,
  chain = default_credential_chain()
)
}
\arguments{
\item{scope}{Optional character string specifying the authentication scope.}

\item{tenant_id}{Optional character string specifying the tenant ID for
authentication.}

\item{client_id}{Optional character string specifying the client ID for
authentication.}

\item{client_secret}{Optional character string specifying the client secret
for authentication.}

\item{use_cache}{Character string indicating the caching strategy. Defaults
to \code{"disk"}. Options include \code{"disk"} for disk-based caching or \code{"memory"}
for in-memory caching.}

\item{offline}{Logical. If \code{TRUE}, adds 'offline_access' to the scope to request a 'refresh_token'.
Defaults to \code{TRUE}.}

\item{chain}{A list of credential objects, where each element must inherit
from the \code{Credential} base class. Credentials are attempted in the order
provided until \code{get_token} succeeds.}
}
\value{
A function that retrieves and returns an authentication token when
called.
}
\description{
Creates a token provider function that retrieves authentication credentials
and returns a callable token getter. This function handles the credential
discovery process and returns the token acquisition method from the
discovered credential object.
}
\examples{
# In non-interactive sessions, this function will return an error if the
# environment is not set up with valid credentials. In an interactive session
# the user will be prompted to attempt one of the interactive authentication flows.
\dontrun{
token_provider <- get_token_provider(
  scope = "https://graph.microsoft.com/.default",
  tenant_id = "my-tenant-id",
  client_id = "my-client-id",
  client_secret = "my-secret"
)
token <- token_provider()
}

}
\seealso{
\code{\link[=get_request_authorizer]{get_request_authorizer()}}, \code{\link[=get_token]{get_token()}}
}
