% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_save}
\alias{am_save}
\title{Save an Automerge document to binary format}
\usage{
am_save(doc)
}
\arguments{
\item{doc}{An Automerge document (created with \code{am_create()} or \code{am_load()})}
}
\value{
A raw vector containing the serialized document
}
\description{
Serializes an Automerge document to the standard binary format,
which can be saved to disk or transmitted over a network.
The binary format is compatible across all Automerge implementations
(JavaScript, Rust, etc.).
}
\examples{
doc <- am_create()
bytes <- am_save(doc)

# Save to file
file <- tempfile()
writeBin(am_save(doc), file)

unlink(file)
am_close(doc)

}
