% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_get_actor_hex}
\alias{am_get_actor_hex}
\title{Get the actor ID as a hex string}
\usage{
am_get_actor_hex(doc)
}
\arguments{
\item{doc}{An Automerge document}
}
\value{
A character string containing the hex-encoded actor ID
}
\description{
Returns the actor ID of an Automerge document as a hex-encoded string.
This is more efficient than converting the raw bytes returned by
\code{\link[=am_get_actor]{am_get_actor()}} using R-level string operations.
}
\examples{
doc <- am_create()
actor_hex <- am_get_actor_hex(doc)
cat("Actor ID:", actor_hex, "\n")

am_close(doc)

}
