% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_null.R
\name{assert_null}
\alias{assert_null}
\title{Assert that the input is NULL}
\usage{
assert_null(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{A value to check.}

\item{msg}{A character string containing the error message to display if \code{x} is not NULL.}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is NULL, otherwise aborts with the error message specified by \code{msg}.
}
\description{
This function asserts that the input is NULL and aborts with an error message if it is not.
}
\examples{
assert_null(NULL)  # Passes

try({
 assert_null(1)  # Throws default error
 assert_null(1, msg = "Custom error message")  # Throws custom error
})

}
