% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arlc_fct_get_best_apriori_thresholds.R
\name{arlc_fct_get_best_apriori_thresholds}
\alias{arlc_fct_get_best_apriori_thresholds}
\title{Get Best Apriori Thresholds}
\usage{
arlc_fct_get_best_apriori_thresholds(transactions, support_range, conf)
}
\arguments{
\item{transactions}{A transaction dataset of class \code{transactions} from the \code{arules} package.}

\item{support_range}{A numeric vector specifying the range of support values to be tested.}

\item{conf}{A numeric value (0.5 or 1.0) specifying the confidence value.}
}
\value{
A numeric vector containing the best support, best confidence, highest lift, and the number of rules found.
The return value is a named vector with elements \code{best_support}, \code{best_confidence}, \code{best_lift}, and \code{len_rules}.
}
\description{
This function finds the best support and confidence thresholds for the Apriori algorithm
to maximize the lift of the generated association rules.
}
\details{
This function iterates through the given ranges of support and confidence values,
applies the Apriori algorithm to find association rules for each pair of values, and selects
the pair that produces rules with the highest lift.
}
\examples{
\donttest{
library(arlclustering)
sample_gml_file <- system.file("extdata", "karate.gml", package = "arlclustering")
g <- arlc_get_network_dataset(sample_gml_file, "Karate Club")
trans <- arlc_gen_transactions(g$graph)
supportRange <- seq(0.1, 0.2, by = 0.1)
Conf <- 0.5
best_thresholds <- arlc_fct_get_best_apriori_thresholds(trans, supportRange, Conf)
}

}
