% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arlc_fct_clean_transactions.R
\name{arlc_fct_clean_transactions}
\alias{arlc_fct_clean_transactions}
\title{Clean Transactions by Removing Overlapping Sets}
\usage{
arlc_fct_clean_transactions(all_sets)
}
\arguments{
\item{all_sets}{A list of sets where each set is a vector of elements.}
}
\value{
A list of sets with fully overlapped sets removed.
}
\description{
This function processes a list of sets and removes those that are fully overlapped by other sets.
}
\details{
The function iterates through each set and checks if it is fully overlapped by any other set. If a set is fully overlapped, it is excluded from the final list of sets. The result is a list of sets with no fully overlapped sets.
}
\examples{
\donttest{
library(arlclustering)
# Create a sample transactions dataset
sample_gml_file <- system.file("extdata", "karate.gml", package = "arlclustering")
g <- arlc_get_network_dataset(sample_gml_file, "Karate Club")
trans <- arlc_gen_transactions(g$graph)
supportRange <- seq(0.1, 0.2, by = 0.1)
Conf <- 0.5
params <- arlc_get_apriori_thresholds(trans, supportRange, Conf)
grossRules <- arlc_gen_gross_rules(trans, params$minSupp, params$minConf, 1, params$lenRules)
nonRR_rules <- arlc_get_NonR_rules(grossRules$GrossRules)
NonRRSig_rules <- arlc_get_significant_rules(trans, nonRR_rules$FiltredRules)
cleaned_rules <- arlc_clean_final_rules(NonRRSig_rules$FiltredRules)

vec <- lapply(cleaned_rules, function(v) unique(unlist(v)))
vec2 <- split(vec, sapply(vec, `[`, 1))
sorted_result <- lapply(vec2, function(v) sort(unique(unlist(v))))

clusters <- arlc_fct_clean_transactions(sorted_result)

message (clusters)
}

}
