% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explainer.R
\name{explainer}
\alias{explainer}
\title{Generic explainer}
\usage{
explainer(X, xname = NULL, ...)
}
\arguments{
\item{X}{a data.frame or a vector}

\item{xname}{name of the data to be printed. If missing then the
name of variable passed as \code{X} will be used}

\item{...}{other parameters required for other methods of \code{explainer}
To see the parameters for numeric methods, use \code{?explainer.numeric} and
similarly for other methods (\code{?explainer.factor} etc.)}
}
\value{
Prints the information on the console. For print information for
the individual methods, see their documentation. Returns nothing.
}
\description{
Generic function for printing the details of data. Based on
the data type, this calls the appropriate method.
}
\details{
Current methods for \code{explainer} are for data.frame, numeric, integer,
character and factor vectors. To get the list of all available methods type
the command \code{methods(explainer)}.
}
\examples{
# for numeric
explainer(mtcars)
explainer(mtcars$mpg) #same as explainer.numeric(mtcars$mpg)
# for factor
explainer(as.factor(mtcars$cyl)) #same as explainer.factor(as.factor(mtcars$cyl))

}
