% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCassociation.R
\name{CCassociation}
\alias{CCassociation}
\title{Association (Correlation) between Continuous (numeric) Variables}
\usage{
CCassociation(
  numtb,
  use = "everything",
  normality_test_method,
  normality_test_pval,
  method1 = c("auto", "pearson", "kendall", "spearman"),
  methodMat1 = NULL,
  methods_used
)
}
\arguments{
\item{numtb}{a data frame with all the numerical columns. This should
have at least two columns}

\item{use}{an optional character string giving a method for computing
association in the presence of missing values. This must be (complete or an
abbreviation of) one of the strings "everything", "all.obs",
"complete.obs", "na.or.complete", or "pairwise.complete.obs". If use is
"everything", NAs will propagate conceptually, i.e., a resulting value will
be NA whenever one of its contributing observations is NA. If use is
"all.obs", then the presence of missing observations will produce an error.
If use is "complete.obs" then missing values are handled by case wise
deletion (and if there are no complete cases, that gives an error).
"na.or.complete" is the same unless there are no complete cases, that gives
NA}

\item{normality_test_method}{method for normality test for a variable.
 Values can be \code{shapiro}
 for Shapiro-Wilk test or
 \code{'anderson'} for 'Anderson-Darling' test of normality or \code{ks} for
'Kolmogorov-Smirnov'}

\item{normality_test_pval}{significance level for normality tests.
Default is 0.05}

\item{method1}{method for association between continuous-continuous
variables. values can be \code{"auto", "pearson",  "kendall", "spearman"}.
See details for more information.}

\item{methodMat1}{method dataframe like methodMats from the function \code{
association}}

\item{methods_used}{a square data.frame which will store the type of
association used between the variables. Dimension will be
number of variables * number of variables.}
}
\value{
a list of two tables with number of rows and column equal to number
of columns in \code{numtb}:
\describe{
 \item{r}{Table containing correlation values}
 \item{r_pvalue}{Table containing p-value for the correlation test}
}
}
\description{
\code{CCassociation} finds correlation between all the variables in data
with only numeric columns
}
\details{
This function calls \code{cor} function to calculate the correlation values.
The difference is that this doesn't take method as parameter, instead it
decides the methods itself using normality tests. If the variables satisfy
the assumption of Pearson correlation, then pearson correlation is calculated.
Otherwise Spearman is calculated. To learn more, check the
\code{\link[stats]{cor}}
}
\seealso{
\code{\link{association}} for association between any type of variables,
\code{\link{QQassociation}} for Association between Categorical variables,
\code{\link{CQassociation}} for Association between Continuous-Categorical
variables
}
