#Testing the weighted_trawl acfs
p<-function(x){
  tau <-2
  sin(2*pi*x/tau)
}


g<-function(x){
  lambda <-0.5
  exp(-lambda*x)
}
#Testing correct length of output
expect_equal(length(kernel_generic_trawl_acf(p, g, c(0,1,2))), 3, tolerance=0)
expect_equal(length(kernel_trawl_acf(p, "Exp", 0.5, c(0,1,2))),3, tolerance=0)
expect_equal(length(kernel_trawl_acf_exp_sin(c(0,1,2), lambda=0.5, tau=2)),3,tolerance=0)

#Testing correct computations of acf
expect_equal(kernel_generic_trawl_acf(p, g, 0),kernel_trawl_acf(p, "Exp", 0.5, 0),tolerance=0.0001)
expect_equal(kernel_generic_trawl_acf(p, g, 0.1),kernel_trawl_acf(p, "Exp", 0.5, 0.1),tolerance=0.0001)
expect_equal(kernel_generic_trawl_acf(p, g, 0.2),kernel_trawl_acf(p, "Exp", 0.5, 0.2),tolerance=0.0001)
expect_equal(kernel_generic_trawl_acf(p, g, 0.3),kernel_trawl_acf(p, "Exp", 0.5, 0.3),tolerance=0.0001)
expect_equal(kernel_generic_trawl_acf(p, g, 1),kernel_trawl_acf(p, "Exp", 0.5, 1),tolerance=0.0001)
expect_equal(kernel_generic_trawl_acf(p, g, 2),kernel_trawl_acf(p, "Exp", 0.5, 2),tolerance=0.0001)
expect_equal(kernel_generic_trawl_acf(p, g, 3),kernel_trawl_acf(p, "Exp", 0.5, 3),tolerance=0.0001)
expect_equal(kernel_generic_trawl_acf(p, g, 4),kernel_trawl_acf(p, "Exp", 0.5, 4),tolerance=0.0001)

expect_equal(kernel_trawl_acf_exp_sin(0, lambda=0.5, tau=2),kernel_trawl_acf(p, "Exp", 0.5, 0),tolerance=0.001)
expect_equal(kernel_trawl_acf_exp_sin(0.1, lambda=0.5, tau=2),kernel_trawl_acf(p, "Exp", 0.5, 0.1),tolerance=0.001)
expect_equal(kernel_trawl_acf_exp_sin(0.2, lambda=0.5, tau=2),kernel_trawl_acf(p, "Exp", 0.5, 0.2),tolerance=0.001)
expect_equal(kernel_trawl_acf_exp_sin(0.3, lambda=0.5, tau=2),kernel_trawl_acf(p, "Exp", 0.5, 0.3),tolerance=0.001)
expect_equal(kernel_trawl_acf_exp_sin(1, lambda=0.5, tau=2),kernel_trawl_acf(p, "Exp", 0.5, 1),tolerance=0.001)
expect_equal(kernel_trawl_acf_exp_sin(2, lambda=0.5, tau=2),kernel_trawl_acf(p, "Exp", 0.5, 2),tolerance=0.001)
expect_equal(kernel_trawl_acf_exp_sin(3, lambda=0.5, tau=2),kernel_trawl_acf(p, "Exp", 0.5, 3),tolerance=0.001)
expect_equal(kernel_trawl_acf_exp_sin(4, lambda=0.5, tau=2),kernel_trawl_acf(p, "Exp", 0.5, 4),tolerance=0.001)




