% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{plot_design.factorial_crd}
\alias{plot_design.factorial_crd}
\title{Plot Factorial Complete Randomized Designs (crd)}
\usage{
plot_design.factorial_crd(
  design,
  ncols,
  nrows,
  y = "row",
  factor_name = "A",
  labels = "plots",
  width = 1,
  height = 1,
  space_width = 0.95,
  space_height = 0.85,
  reverse_y = FALSE,
  reverse_x = FALSE
)
}
\arguments{
\item{design}{outdesign from \code{agricolae} package}

\item{ncols}{integer value, choose the number of columns to which the experiment should be plotted}

\item{nrows}{integer value, choose the number of rows to which the experiment should be plotted}

\item{y}{Describes the y coordinates of a experiment design, default is row}

\item{factor_name}{Which factor should be used for plotting, needs to be a column in outdesign$book}

\item{labels}{string indicates the column of which the labels should be displayed}

\item{width}{numeric value, describes the width of a plot in an experiment}

\item{height}{numeric value, describes the height of a plot in an experiment}

\item{space_width}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of width}

\item{space_height}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of height}

\item{reverse_y}{boolean, should the plots of the experiment be changed in reverse order in Row direction? use reverse_y=TRUE to have same sketch as in agricolae. default:reverse_y=FALSE}

\item{reverse_x}{boolean, should the plots of the experiment be changed in reverse order in column direction? default:reverse_x=FALSE}
}
\value{
\code{ggplot} graphic that can be modified, if wished
}
\description{
Plot a design of a factorial experiment with completely randomized design (crd) from design.ab
}
\examples{
library(agricolaeplotr)
library(agricolae)
trt<-c(3,2) # factorial 3x2
outdesign <- design.ab(trt, r=3, serie=2,design = 'crd')
plot_design.factorial_crd(outdesign,ncols = 8,nrows = 6)
plot_design.factorial_crd(outdesign,reverse_y = TRUE,ncols = 8,nrows = 6)
plot_design.factorial_crd(outdesign,reverse_y = TRUE,reverse_x = TRUE,ncols = 8,nrows = 6)
}
