% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afmReadJPKMultiIndent.R
\name{afmReadJPKMultiIndent}
\alias{afmReadJPKMultiIndent}
\title{Read Nanowizard JPK ascii file containing a multi-indentation experiment}
\usage{
afmReadJPKMultiIndent(
  filename,
  path = "",
  FColStr = "Vertical Deflection",
  ZColStr = "Height (measured & smoothed)",
  tColStr = "Segment Time",
  silent = FALSE
)
}
\arguments{
\item{filename}{String with the name of the jpk file.}

\item{path}{Path to the folder where the file is.}

\item{FColStr}{String with a pattern identifying the Force column.}

\item{ZColStr}{String with a pattern identifying the Z column.}

\item{tColStr}{String with a pattern identifying the Time column.}

\item{silent}{Logical value. If TRUE suppresses the message indicating the name of the curve being processed
(useful for batch-processing large number of curves). Defaults to FALSE}
}
\value{
A afmdata structure list containing a field 'data' which is a data frame with 
variables Force, Z, Time (if aplicable) and Segment ("approach", "retract" and/or "pause") and 
a field 'params' which is a list with the fields 'curvename' and 'SpringConstant'.
}
\description{
Read an ascii JPK file containing several approach - pause 
segments and only one retract segment.
}
\examples{
data <- afmReadJPKMultiIndent("force-save-JPK-multiIndent.txt.gz",path = path.package("afmToolkit"))
# Processing
data <- afmContactPoint(data, width = 100, mul1 = 1, mul2 = 10)
data <- afmDetachPoint(data, width = 100, mul1 = 1, mul2 = 10)
data <- afmBaselineCorrection(data)
data <- afmZeroPointSlope(data, fstar = 1)
data <- afmIndentation(data)
data <- afmRelax(data, model = "power", type = "CH", tmax = 5, plt = TRUE) 

}
