% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesopR-package.R, R/data-aesops-fables.R
\docType{data}
\name{aesops_fables}
\alias{aesops_fables}
\title{Aesop's Fables Corpus}
\format{
A tibble with 147 rows and the following variables:
\describe{
  \item{fable_id}{Character string uniquely identifying the fable
    (e.g., \code{"001"}, \code{"075"}).}
  \item{title}{Title of the fable.}
  \item{full_text}{Full narrative text of the fable.}
  \item{moral}{The moral or lesson associated with the fable.}
  \item{source_url}{URL of the original Library of Congress page.}
}

A tibble with 147 rows and the following variables:
\describe{
  \item{fable_id}{Character string uniquely identifying the fable
    (e.g., \code{"001"}, \code{"075"}).}
  \item{title}{Title of the fable.}
  \item{full_text}{Full narrative text of the fable.}
  \item{moral}{The moral or lesson associated with the fable.}
  \item{source_url}{URL of the original Library of Congress page.}
}
}
\source{
Library of Congress, ``Aesop's Fables''

Library of Congress, ``Aesop's Fables''
}
\usage{
aesops_fables

aesops_fables
}
\description{
A dataset containing 147 of Aesop's Fables retrieved from the
Library of Congress public domain collection.

A dataset containing 147 of Aesop's Fables retrieved from the
Library of Congress public domain collection.
}
\details{
Each row represents a single fable and includes metadata, the full narrative
text, and the associated moral.


The texts were scraped from \url{https://read.gov/aesop/} and are believed to
be in the public domain. Text has been minimally cleaned to preserve original
phrasing and narrative structure.

Each row represents a single fable and includes metadata,
the full narrative text, and the associated moral.


The texts were scraped from \url{https://read.gov/aesop/} and are
believed to be in the public domain. Text has been minimally cleaned
to preserve original phrasing and narrative structure.
}
\examples{
aesops_fables

if (requireNamespace("dplyr", quietly = TRUE)) {
  aesops_fables |>
    dplyr::filter(fable_id == "075") |>
    dplyr::select(title, moral)
}

aesops_fables

aesops_fables |>
  dplyr::filter(fable_id == "075") |>
  dplyr::select(title, moral)

}
\keyword{datasets}
