% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot}
\alias{autoplot}
\alias{autoplot.tsd}
\alias{autoplot.tsd_onset}
\alias{autoplot.tsd_onset_and_burden}
\alias{autoplot.tsd_growth_warning}
\title{Autoplot a \code{tsd} object}
\usage{
autoplot(object, ...)

\method{autoplot}{tsd}(
  object,
  line_width = 0.7,
  obs_size = 2,
  text_family = "sans",
  time_interval_step = "5 weeks",
  ...
)

\method{autoplot}{tsd_onset}(
  object,
  disease_color = "black",
  line_width = 0.7,
  obs_size = 2,
  alpha_warning = 0.2,
  alpha_ribbon = 0.1,
  text_family = "sans",
  legend_position = "bottom",
  time_interval_step = "5 weeks",
  ...
)

\method{autoplot}{tsd_onset_and_burden}(
  object,
  y_lower_bound = 5,
  factor_to_max = 2,
  disease_color = "#009DD1",
  season_start = 21,
  season_end = season_start - 1,
  time_interval_step = "3 weeks",
  text_burden_size = 10/2.8,
  fill_alpha = c(0.45, 0.6, 0.75, 0.89, 1),
  text_family = "sans",
  line_color = "black",
  line_type = "solid",
  vline_color_onset = "#bf212f",
  vline_linetype_onset = "dashed",
  vline_color_offset = "#006f3c",
  vline_linetype_offset = "dotted",
  line_width = 1,
  y_scale_labels = scales::label_comma(big.mark = ".", decimal.mark = ","),
  theme_custom = ggplot2::theme_bw(),
  legend_position = "right",
  ...
)

\method{autoplot}{tsd_growth_warning}(
  object,
  k = 5,
  skip_current_season = TRUE,
  line_width = 1,
  text_family = "sans",
  legend_position = "bottom",
  breaks_y_axis = 8,
  ...
)
}
\arguments{
\item{object}{A \code{tsd_growth_warning} object}

\item{...}{Additional arguments (not used).}

\item{line_width}{A numeric specifying the width of line connecting observations.}

\item{obs_size}{A numeric, specifying the size of observational points.}

\item{text_family}{A character specifying the font family for the text labels.}

\item{time_interval_step}{A character vector specifying the time interval and how many time steps are desired
on the x-axis, e.g. '10 days', '4 weeks', or '3 months'.}

\item{disease_color}{A character specifying the base color of the disease.}

\item{alpha_warning}{A numeric specifying the alpha (transparency) for the observations with a
seasonal_onset_alarm (first plot) or significantly positive growth rate (second plot).}

\item{alpha_ribbon}{A numeric specifying the alpha for the confidence intervals of the growth rate.}

\item{legend_position}{A character specifying the position of the legend on the plot.}

\item{y_lower_bound}{A numeric specifying the lower bound of the y-axis.}

\item{factor_to_max}{A numeric specifying the factor to multiply the high burden level for extending the y-axis.}

\item{season_start, season_end}{Integers giving the start and end weeks of the seasons to
stratify the observations by.}

\item{text_burden_size}{A numeric specifying the size of the text labels.}

\item{fill_alpha}{A numeric vector specifying the transparency levels for the fill colors of burden levels.
Must match the number of levels.}

\item{line_color}{A character specifying the color of the line connecting observations.}

\item{line_type}{A character specifying the line type for observation line.}

\item{vline_color_onset}{A character specifying the color of the vertical seasonal onset line.}

\item{vline_linetype_onset}{A character specifying the line type for the seasonal onset line.}

\item{vline_color_offset}{A character specifying the color of the vertical seasonal offset line.}

\item{vline_linetype_offset}{A character specifying the line type for the seasonal offset line.}

\item{y_scale_labels}{A function to format y-axis labels.}

\item{theme_custom}{A function with a ggplot2 theme, specifying the theme to apply to the plot.}

\item{k}{An integer specifying the window size used to create the \code{tsd_onset} object.}

\item{skip_current_season}{A logical. Do you want to skip your current season?}

\item{breaks_y_axis}{A numeric specifying how many breaks to show on the y-axis.}
}
\value{
A 'ggplot' object for visualizing the \code{tsd} data.

A 'ggplot' object for visualizing the \code{tsd_onset} data.

A 'ggplot' object for visualizing the \code{tsd_onset_and_burden} data for the current season.

A 'ggplot' object for visualizing the \code{tsd_growth_warning} data.
}
\description{
Generates a complete 'ggplot' object suitable for visualizing time series data in a
\code{tsd}, \code{tsd_onset}, \code{tsd_onset_and_burden} or \code{tsd_growth_warning} object.

\code{autoplot(tsd)}
\itemize{
\item Generates points for each observation and connects them with a line.
}

\code{autoplot(tsd_onset)}
\itemize{
\item The first plot generates a line connecting the observations.
The transparency of the points reflects if seasonal onset has occurred.
\item The second plot presents the growth rate for each observation along with confidence intervals.
The transparency of the points indicates whether a growth warning condition is met.
}

\code{autoplot(tsd_onset_and_burden)}
\itemize{
\item Generates a line connecting the observations in the current season, along with colored regions
representing different burdens levels and a vertical line indicating seasonal onset.
The y-axis is scaled with \code{ggplot2::scale_y_log10} to give better visualisation of the burden levels.
}
}
\examples{
set.seed(345)
# Create an example `tsd` object
time_series <- generate_seasonal_data()
autoplot(time_series)

# Create an `tsd_onset` object
time_series_with_onset <- seasonal_onset(
  tsd = time_series,
  k = 3,
  level = 0.95,
  family = "quasipoisson"
)
autoplot(time_series_with_onset)

\donttest{
# Define `disease_threshold`
disease_threshold <- 150

# Create a `tsd_onset_and_burden` object
tsd_onset_burden <- combined_seasonal_output(
  tsd = time_series,
  disease_threshold = disease_threshold
)
autoplot(tsd_onset_burden)
}
# Create an `tsd_onset` object
tsd_onset <- seasonal_onset(
  tsd = time_series,
  k = 5,
  family = "quasipoisson",
  season_start = 21,
  only_current_season = FALSE
)

tsd_growth_warning <- consecutive_growth_warnings(tsd_onset)

autoplot(tsd_growth_warning)

}
