% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Adplotfnc.R
\name{adplot}
\alias{adplot}
\title{Creates Ad-plot for the provided data.}
\usage{
adplot(X, title = "Ad-plot", xlab = "x", lcol = "black", rcol = "grey60", ...)
}
\arguments{
\item{X}{an \eqn{n} by \eqn{1} matrix, equivalently, a column vector of length \eqn{n}, where \eqn{n} is the number of observations.}

\item{title}{title of the plot, \emph{Ad-plot} by default.}

\item{xlab}{\eqn{x}-axis label, \eqn{x} by default.}

\item{lcol}{color of the points corresponding to the data that are less than or equal to the sample average, \emph{black} by default.}

\item{rcol}{color of the points corresponding to the data that are greater than the sample average, \emph{grey60} by default.}

\item{...}{other graphical parameters.}
}
\value{
Ad-plot
}
\description{
Ad-plot identifies the characteristics of the distribution such as symmetry, skewness, and outliers of the data set.
}
\examples{
   set.seed(0)
   X1 <- matrix(rnorm(50, mean = 2, sd = 5))
   adplot(X1)

   X2 <- matrix(rf(50, df1 = 10, df2 = 5))
   adplot(X2)

   X3 <- matrix(rbeta(50, shape1 = 10, shape2 = 2))
   adplot(X3, title="", lcol = "blue", rcol = "red")
}
\references{
Wijesuriya, U. A. (2025). Ad-plot and Ud-plot for Determining Distributional
            Characteristics and Normality.
            \emph{Communications in Statistics-Theory and Methods}, \doi{10.1080/03610926.2024.2440583}.
}
