% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tte_sources.R
\docType{data}
\name{death_event}
\alias{death_event}
\alias{lastalive_censor}
\alias{pd_event}
\alias{lasta_censor}
\alias{rand_censor}
\alias{trts_censor}
\title{Pre-Defined Time-to-Event Source Objects}
\usage{
death_event

lastalive_censor

pd_event

lasta_censor

rand_censor

trts_censor
}
\description{
These pre-defined \code{tte_source} objects can be used as input to \code{admiral::derive_param_tte()}.
}
\details{
To see the definition of the various objects simply print the object in the
R console, e.g. \code{print(death_event)}. For details of how to use these objects
please refer to \code{\link[admiral:derive_param_tte]{admiral::derive_param_tte()}}.

Printing an object will display input dataset_name, filter (if applicable), date variable,
and appropriate values for \code{EVNTDESC}, \code{CNSDTDSC}, \code{SRCDOM}, \code{SRCVAR}, and \code{SRCSEQ}.
}
\examples{
# This shows the definition of all pre-defined `tte_source` objects that ship
# with {admiralonco}
for (obj in admiral::list_tte_source_objects(package = "admiralonco")$object) {
  cat(obj, "\n")
  print(get(obj, envir = getNamespace("admiralonco")))
  cat("\n")
}
}
\seealso{
\code{\link[admiral:derive_param_tte]{admiral::derive_param_tte()}}, \code{\link[admiral:tte_source]{admiral::tte_source()}}, \code{\link[admiral:event_source]{admiral::event_source()}},
\code{\link[admiral:censor_source]{admiral::censor_source()}}
}
\concept{source_specifications}
\keyword{source_specifications}
