% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sus_alt.R
\name{sus_alt}
\alias{sus_alt}
\title{Check an R markdown document for suspicious alt text.}
\usage{
sus_alt(rmd_path = NULL, lan = detect_html_lang(lines))
}
\arguments{
\item{rmd_path}{Path to the Rmd that contains image tags to check.}

\item{lan}{Identify the language of text content. Attempts to find a lang
attribute value from the rmd document. Alternatively, use a character string
such as "en".}
}
\value{
Line numbers of images that has alt text equal to placeholder values.
}
\description{
Checks if an R markdown contains images alt text is equal to alt attribute
placeholder values, including: 'nbsp', 'spacer' and src attribute value
(filename).
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
# create a testfile
rmd <- tempfile("testing", fileext = ".rmd")
# write basic markdown content
writeLines('---
title: "Suspicious Alt Text"
author: "Some Author"
date: "`r format(Sys.Date(), "\%d \%b \%Y")`"
output: html_document
---

 ```{r setup, include=FALSE}
knitr::opts_chunk$set(echo = TRUE)
```

## R Markdown

![nbsp](some_img)

![another_img](another_img)',
  con = rmd
)

# test the file for suspicious alt text
sus_alt(rmd, lan = "en")

# Adjust the document header to improve screen reader accessibility
access_head(rmd, lan = "en")
\dontshow{
setwd(.old_wd)
}

}
