% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{artifacts}
\alias{artifacts}
\title{Accelerometer Artifact Correction}
\usage{
artifacts(counts, thresh, counts_classify = NULL)
}
\arguments{
\item{counts}{Integer vector with accelerometer count values.}

\item{thresh}{Integer value specifying the smallest count value that should 
be considered an artifact.}

\item{counts_classify}{Integer vector with accelerometer count values to 
base artifact classification on, but not to adjust. Mainly included for 
triaxial data, where you might want to define artifacts based on 
vertical-axis counts but then actually adjust the triaxial sum or vector 
magnitude counts.}
}
\value{
Integer vector equivalent to \code{counts} except where artifacts 
were adjusted.
}
\description{
Corrects abnormally high count values in accelerometer data by replacing 
such values with the average of neighboring count values. Returns integer 
vector despite the average calculation often producing a decimal; this 
follows the convention used in the NCI's SAS programs 
(\url{http://riskfactor.cancer.gov/tools/nhanes_pam}).
}
\examples{
# Load accelerometer data for first 5 participants in NHANES 2003-2004
data(unidata)

# Get data from ID number 21007
counts.part3 <- unidata[unidata[, "seqn"] == 21007, "paxinten"]

# Replace counts > 10,000 with average of neighboring values
counts.part3.corrected <- artifacts(counts = counts.part3, thresh = 10000)

}
\references{
National Cancer Institute. Risk factor monitoring and methods: SAS programs 
for analyzing NHANES 2003-2004 accelerometer data. Available at: 
\url{http://riskfactor.cancer.gov/tools/nhanes_pam}. Accessed Aug. 19, 2018.
}
