% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_robustness.R
\name{plot_robustness}
\alias{plot_robustness}
\title{Plot Bayes Factor Robustness Check}
\usage{
plot_robustness(
  x,
  bftype = "BF10",
  log = FALSE,
  mu_range = c(0, 0.3),
  sigma_range = c(0.25, 1),
  mu_steps = 40,
  sigma_steps = 40,
  cores = 1,
  ...
)
}
\arguments{
\item{x}{object of class \code{"ab"}.}

\item{bftype}{character that specifies which Bayes factor is plotted. Either
\code{"BF10"}, \code{"BF01"}, \code{"BF+0"}, \code{"BF0+"}, \code{"BF-0"},
or \code{"BF0-"}.}

\item{log}{Boolean that specifies whether the log Bayes factor is plotted.}

\item{mu_range}{numeric vector of length two that specifies the range of
\code{mu_psi} values to consider.}

\item{sigma_range}{numeric vector of length two that specifies the range of
\code{sigma_psi} values to consider.}

\item{mu_steps}{numeric value that specifies in how many discrete steps the
interval \code{mu_range} is partitioned.}

\item{sigma_steps}{numeric value that specifies in how many discrete steps
the interval \code{sigma_range} is partitioned.}

\item{cores}{number of cores used for the computations.}

\item{...}{further arguments passed to \code{filled.contour}.}
}
\value{
Returns a \code{data.frame} with the \code{mu_psi} values,
  \code{sigma_psi} values, and corresponding (log) Bayes factors.
}
\description{
Function for plotting Bayes factor robustness check results (i.e., prior
sensitivity analysis).
}
\details{
The plot shows how the Bayes factor changes as a function of the
  normal prior location parameter \code{mu_psi} and the normal prior scale
  parameter \code{sigma_psi} (i.e., a prior sensitivity analysis with respect
  to the normal prior on the test-relevant log odds ratio).
}
\examples{
\dontrun{
# synthetic data
data <- list(y1 = 10, n1 = 28, y2 = 14, n2 = 26)

# Bayesian A/B test with default settings
ab <- ab_test(data = data)

# plot robustness check (i.e., prior sensitivity analysis)
p <- plot_robustness(ab)

# returned object contains the Bayes factors for the different prior settings
head(p)
}
}
\author{
Quentin F. Gronau
}
