% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio_calculations.R
\name{multiple_matrix_ratios}
\alias{multiple_matrix_ratios}
\title{Calculate Matrix Ratios
This function calculates the  ratios for a given data set,
based on the shared time points for each matrix concentration sample.
The user can input multiple tissues for which ratios should be calculated.}
\usage{
multiple_matrix_ratios(
  data,
  matrix_col,
  conc_col,
  units_col,
  groups = c("NFRLT", "USUBJID"),
  spec1,
  spec2
)
}
\arguments{
\item{data}{A data frame containing the concentration data.}

\item{matrix_col}{A character string specifying the column name for the matrix type.}

\item{conc_col}{A character string specifying the column name for the concentration data.}

\item{units_col}{A character string specifying the column name for the units.}

\item{groups}{A character vector of grouping variables to use for the analysis.
Must include time column, USUBJID, and optionally, other grouping variables.}

\item{spec1}{A character string specifying the value for
the first specimen type(s) in the matrix_col.}

\item{spec2}{A character string specifying the value for
the second specimen type(s) in the matrix_col.}
}
\value{
A data frame containing the ratios.
}
\description{
The ratios are calculated as specimen1 / specimen 2.
}
\examples{
data <- data.frame(
  USUBJID = c("A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "A", "A"),
  NFRLT = c(0, 1, 2, 0, 1, 2, 0, 1, 2, 0, 1, 2),
  MATRIX = c(
    "BLOOD", "BLOOD", "BLOOD", "PLASMA", "PLASMA", "PLASMA",
    "BRAIN", "BRAIN", "BRAIN", "LIVER", "LIVER", "LIVER"
  ),
  CONC = c(10, 20, 15, 25, 30, 40, 5, 10, 8, 12, 18, 16),
  UNITS = rep("ng/mL", 12)
)
multiple_matrix_ratios(data, "MATRIX", "CONC", "UNITS", c("NFRLT", "USUBJID"), "BLOOD", "PLASMA")

}
