% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filtering_datasets.R
\name{generic_filter}
\alias{generic_filter}
\title{Filtering a data set following the 3-tables format}
\usage{
generic_filter(
  var.data,
  meta.samp.data,
  meta.var.data,
  NUM = FALSE,
  ls.num = NULL,
  FACT = FALSE,
  ls.fact = NULL
)
}
\arguments{
\item{var.data}{Data.frame corresponding to the dataMatrix of your 3-tables data set}

\item{meta.samp.data}{Data.frame corresponding to the sampleMetadata of your 3-tables data set}

\item{meta.var.data}{Data.frame corresponding to the variableMetadata of your 3-tables data set}

\item{NUM}{Logical; indicates whether some filtering based on numeric metadata columns should be performed}

\item{ls.num}{List of character vectors; each vector corresponds to a numerical filter to perform; see Details for vector content}

\item{FACT}{Logical; indicates whether some filtering based on qualitative metadata columns should be performed}

\item{ls.fact}{List of character vectors; each vector corresponds to a qualitative filter to perform; see Details for vector content}
}
\value{
a \code{list} containing the 3 tables, filtered according to the criteria input
}
\description{
generic_filter
This function allows to filter variables and samples according to factors or numerical values.
It needs 3 datasets: the data matrix, the variables' metadata, the samples' metadata.
It generates 3 new datasets corresponding to the 3 inputs filtered.
}
\details{
The vectors inside \code{ls.num} and \code{ls.fact} must follow a dedicated format.
For \code{ls.fact}, each vector must be constituted of exactly 3 character strings in the following order:
(i) the name of a column to filter in one of the metadata table,
(ii) the modality inside this column to get rid off,
and (iii) "sample" or "variable" depending on the type of metadata you are filtering (i.e. the table that contains the column to filter).
For \code{ls.num}, each vector must be constituted of 4 to 5 character strings in the following order:
(i) "sample" or "variable" depending on the type of metadata you are filtering (i.e. the table that contains the column to filter),
(ii) the name of the column to filter in the corresponding metadata table,
(iii) the type of numerical filtering to apply, to be chosen from "lower", "upper", "extremity" and "between",
(iv) the threshold to be used for filtering (in case the 'iii' argument is "extremity" or "between", it is the lower threshold),
and (v) in case the 'iii' argument is "extremity" or "between", the upper threshold.
}
\author{
M.Petera
}
