% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{HistoricMLE}
\alias{HistoricMLE}
\title{Historic flood maximum likelihood estimation}
\usage{
HistoricMLE(x, k = NULL, h, threshold, dist = "GenLog", Uncertainty = FALSE)
}
\arguments{
\item{x}{The observed annual maximum sample. A single numeric vector}

\item{k}{The number of exceedances of the threshold}

\item{h}{the time period (years) over which the exceedances occurred.}

\item{threshold}{The perception threshold. This is the threshold we think the k events exceeded.}

\item{dist}{The choice of statistical distribution. Either "GenLog", or "GEV".}

\item{Uncertainty}{Logical argument with a default of FALSE. If TRUE, a data frame of results and uncertainty is also returned.}
}
\value{
A data.frame with one column of flow estimates. The row names denote the name of each estimate. If Uncertainty is TRUE, a list is returned and the second element is a dataframe with estimates and factorial standard errors.
}
\description{
A function to estimate parameters from an annual maximum sample and a known number of historic floods.
}
\details{
This function applies the case where only the number of exceedances are known. Not the case where the discharge of the historic floods is known.
This latter functionality will be added at a later date.
Note that if Uncertainty is set to TRUE, a range of return periods and associated estimates are returned along with uncertainty - quantified as the FSE. In some cases the uncertainty can increase. This happens when the additional information (number of exceedances and time period) does not outweigh an increase to the scale of skew parameter.
The uncertainty calculated is a function of sample size and variance.
}
\examples{
# Get an annual maximum sample and assume 3 exceedances over 100 years
# with a threhsold of 140m 3/s
AM71011 <- GetAM(71011)
HistoricMLE(AM71011$Flow, k = 3, h = 100, threshold = 140)


# Now estimate again but set Uncertainty = TRUE
HistoricMLE(AM71011$Flow, k = 3, h = 100, threshold = 140, Uncertainty = TRUE)

}
\author{
Anthony Hammond
}
