% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-utils.R
\name{find_column}
\alias{find_column}
\title{Find column by pattern matching}
\usage{
find_column(patterns, column_names, verbose = FALSE)
}
\arguments{
\item{patterns}{Character vector of regex patterns to search for.}

\item{column_names}{Character vector of column names to search in.}

\item{verbose}{Logical. If TRUE, prints detailed matching information.}
}
\value{
Integer index of the first matching column, or NULL if no match found.
}
\description{
Searches for a column in a data frame using multiple pattern options.
If multiple columns match, warns the user and returns the first match.
}
\examples{
cols <- c("codigo_faena", "numero_cala", "especie", "especies_capturadas")
species_patterns <- c("especie", "species", "sp")
col_index <- find_column(species_patterns, cols)

}
