% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_appro.R
\name{core_appro}
\alias{core_appro}
\title{Approximated core of the game}
\usage{
core_appro(characteristic_func, n_players = 0, n_rep = 1000, echo)
}
\arguments{
\item{characteristic_func}{The valued function defined on the subsets of the number
of players.}

\item{n_players}{Only used if \code{characteristic_func} is a \code{function}.
The number of players in the game.}

\item{n_rep}{The number of iterations to perform in the algorithm.}

\item{echo}{Only used if \code{method} is \code{appro}. Show progress of the
approximated calculation.}
}
\value{
The vertices of the estimated core
}
\description{
Calculate the vertices of the core of the game following
Camacho et al. (2025)
}
\references{
Camacho, J., Gonçalves-Dosantos, J. C., & Sánchez-Soriano, J. (2025).
A Linear Programming Approach to Estimate the Core in Cooperative Games.
arXiv preprint arXiv:2510.01766.
}
