% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zeronormalizedgame.R
\name{zeronormalizedgame}
\alias{zeronormalizedgame}
\title{0-normalized game}
\usage{
zeronormalizedgame(v, binary = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}
}
\value{
The characteristic function of the 0-normalized game, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
Given a game, this function returns the characteristic function of its 0-normalization.
}
\details{
The 0-normalization of a given \eqn{v\in G^N} is defined by
\eqn{v_0(S)=v(S)-\sum_{i\in S} v(i)} for each \eqn{S \in 2^N}.
}
\examples{
zeronormalizedgame(c(0,3,7,15,17,27,30))
zeronormalizedgame(c(1,5,10,6,11,15,16))
v.random <- rnorm(2^5-1,58,13)
zeronormalizedgame(v.random) == -savingsgame(v.random)
}
\seealso{
\link{normalizedgame}, \link{savingsgame}, \link{strategicallyequivalentcheck}, \link{zeromonotoniccheck}, \link{zeronormalizedcheck}
}
