% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zeronormalizedcheck.R
\name{zeronormalizedcheck}
\alias{zeronormalizedcheck}
\title{0-normalized check}
\usage{
zeronormalizedcheck(v, binary = FALSE, instance = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{instance}{A logical value. By default, \code{instance=FALSE}.}
}
\value{
\code{TRUE} if the game is 0-normalized, \code{FALSE} otherwise. If \code{instance=TRUE} and the game is not 0-normalized, the function also returns a player for whose value is not zero.
}
\description{
This function checks if the given game is 0-normalized.
}
\details{
A game \eqn{v\in G^N} is 0-normalized if \eqn{v(i)=0} for all \eqn{i\in N}.
}
\examples{
v <- c(rep(0, 4), 1, rep(30, 20), rep(3, 5), 50) # v(5)=1
zeronormalizedcheck(v, binary = FALSE, instance = TRUE)
}
\seealso{
\link{normalizedgame}, \link{strategicallyequivalentcheck}, \link{zeromonotoniccheck}, \link{zeronormalizedgame}
}
