% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compromiseadmissiblecheck.R
\name{compromiseadmissiblecheck}
\alias{compromiseadmissiblecheck}
\title{Compromise-admissible check}
\usage{
compromiseadmissiblecheck(v, binary = FALSE, instance = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{instance}{A logical value. By default, \code{instance=FALSE}.}
}
\value{
\code{TRUE} if the game is compromise-admissible, \code{FALSE} otherwise. If \code{instance=TRUE} and \eqn{\{i \in N : m_i(v)>M_i(v)\} \neq \emptyset}, one of the players in that set is also returned.
}
\description{
This function checks if the given game is compromise-admissible.
}
\details{
Let \eqn{v\in G^N}.
The utopia payoff of player \eqn{i\in N} is defined as \eqn{M_i(v)=v(N)-v(N\backslash i)}.
The minimal right of player \eqn{i\in N} is defined as \eqn{m_i(v)=\max_{S:i\in S}(v(S)-\sum_{j\in S\backslash i}M_j(v))}.

The game \eqn{v\in G^N} is said to be compromise-admissible if its core-cover is not empty, that is, if the following conditions hold:

1) \eqn{m(v)\leq M(v)}.

2) \eqn{\sum_{i\in N}m_{i}(v)\leq v(N)\leq \sum_{i\in N}M_i(v)}.
}
\examples{
compromiseadmissiblecheck(c(0,0,0,0,10,40,30,60,10,20,90,90,90,130,160))
compromiseadmissiblecheck(c(1,2,2), instance=TRUE)

# What if the game is a cost game?
cost.v <- c(30, 20, 50, 40, 60, 60, 75) # compromise-admissible cost game
compromiseadmissiblecheck(-c(30, 20, 50, 40, 60, 60, 75))
}
