\name{orderADD}
\alias{orderADD}

\title{
Recorde an order's trade
}
\description{
This function is used to submit buy and sell orders on the Nobitex website
}
\usage{
orderADD(typ, src, dst, amnt, prc, stp = NULL, stpL = NULL, exe = "limit", token)
}

\arguments{
  \item{typ}{
\code{"buy"} is used for placing buy orders, while \code{"sell"} is used for placing sell orders
}
  \item{src}{
   Cryptocurrency sources are defined by lowercase names in the function (e.g., "btc", "eth", "bnb", "paxg").\cr
}
  \item{dst}{
For the Rials or USD system, the destination currency must be set to either \code{"rls"} or \code{"usdt"}.
}
  \item{amnt}{
Amount of cryptocurrency to trade
}
  \item{prc}{
Price of cryptocurrency to trade. The trade price ("prc") depends on the exe's option.
}
\item{stp}{If using stop-loss or OCO, define the stop price here. Default is NULL.
When the market price reaches "stp", "prc" is activated and recorded in the order list.
For a "buy" position, "stp" must be greater than "prc"; for a "sell"" position, "stp" must be less than \code{prc}.
}
\item{stpL}{If using "oco" then stop limit price must be defined. Defualt is NULL.
While "stp" is active, "stpl" is recorded as the trade price; otherwise, "prc" is used.
}
\item{exe}{ Three common ways to configure a trade: regular trading, stop-loss trading, or One-Cancels-the-Other (OCO) trading.\cr
Regular trading:  The \code{limit} will be recorded in \code{prc} as the trade price.
The \code{market} will be recorded in \code{prc} as the nearest trade price to the latest bid or ask, depending on the buyer or seller.\cr
Stop loss trading: \code{stop_limit} and \code{stop_market} are two trade types that depend on price of \code{stp}.\cr
OCO: Using \code{oco} requires defining two price: \code{stp} and \code{stpL}. \cr
}
\item{token}{
  The token is string value obtain from user ID settings in the NOBITEX. If you are not registered on the website, please use the provided \href{https://nobitex.ir/signup/?refcode=592868}{link}.

}
}

\value{
Returns a list: "ok" if the order is recorded successfully on the website; otherwise, "failed".
}


\examples{
\dontrun{
tkn <- "CONTACT WITH AUTHOR"
x <- orderADD(typ = "sell", src = "usdt", dst = "rls", amnt = 5, prc = 1600000,
              + exe = "limit", token = tkn)

x <- orderADD(typ = "sell", src = "usdt", dst = "rls", amnt = 5, prc = 1400000,
              + stp = 1300000, exe = "stop_limit", token = tkn)

x <- orderADD(typ = "sell", src = "usdt", dst = "rls", amnt = 5, prc = 1400000,
              + stp = 1300000, stpL = 1350000, exe = "oco", token = tkn)
}
}
