% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor.R
\name{monitor}
\alias{monitor}
\alias{monitor_start}
\alias{monitor_end}
\alias{monitor_next}
\alias{monitor_plot}
\title{Monitor Time Consumption}
\usage{
monitor_start(monitor_df, section, group = "Total")

monitor_end(monitor_df)

monitor_next(monitor_df, section, group = "Total")

monitor_plot(monitor_df, by = "section", draw_plot = TRUE)
}
\arguments{
\item{monitor_df}{A data table in which the delta times with their respective section names are stored.}

\item{section}{A named section for which to store delta times.}

\item{group}{Optionally pass a broader group name to be able to plot summarised delta times in addition to the detailed ones.
"Total" as default value.}

\item{by}{Use "section" for a detailed plot and "group" for summarised categories.}

\item{draw_plot}{Conditionally draw plots. TRUE by default.}
}
\value{
Returns a small data table with section-, group-names and corresponding delta times.
}
\description{
The monitor functions offer a simple way to keep track of timings and visualize them in charts.
If used throughout a longer syntax it is useful to identify bottlenecks or just get a better feeling
which passages take more time than others.

\code{\link[=monitor_start]{monitor_start()}} starts a new timing and adds this as an observation to the monitoring
data table. Pass NULL as monitor_df if you call the function for the first time to create a new
monitoring data table.

\code{\link[=monitor_end]{monitor_end()}} ends the current timing and calculates corresponding delta.

\code{\link[=monitor_next]{monitor_next()}} ends the current timing and calculates corresponding delta. In addition directly starts
a new timing for a new section.

\code{\link[=monitor_plot]{monitor_plot()}} outputs two charts to visualize the saved delta times.
}
\examples{
# Example data frame
monitor_df <- NULL |> monitor_start("Generate data frame", "Preparation")

my_data <- dummy_data(1000)

# Formats
monitor_df <- monitor_df |> monitor_next("Create formats", "Preparation")

age. <- discrete_format(
    "Total"          = 0:100,
    "under 18"       = 0:17,
    "18 to under 25" = 18:24,
    "25 to under 55" = 25:54,
    "55 to under 65" = 55:65,
    "65 and older"   = 65:100)

sex. <- discrete_format(
    "Total"  = 1:2,
    "Male"   = 1,
    "Female" = 2)

# Evaluations
monitor_df <- monitor_df |> monitor_next("Nested summarise", "Summarise")

all_nested <- my_data |>
    summarise_plus(class      = c(year, sex, age),
                   values     = income,
                   statistics = c("sum", "pct_group", "pct_total", "sum_wgt", "freq"),
                   formats    = list(sex = "sex.", age = "age."),
                   weight     = weight,
                   nesting    = "deepest",
                   na.rm      = TRUE)

monitor_df <- monitor_df |> monitor_next("All summarise", "Summarise")

all_possible <- my_data |>
    summarise_plus(class      = c(year, sex, age),
                   values     = c(probability),
                   statistics = c("sum", "p1", "p99", "min", "max", "freq", "freq_g0"),
                   formats    = list(sex    = "sex.",
                                     age    = "age."),
                   weight     = weight,
                   nesting    = "all",
                   na.rm      = TRUE)

monitor_df <- monitor_df |> monitor_end()

# For detailed plot
monitor_df |> monitor_plot()

# For summarised plot
monitor_df |> monitor_plot(by = "group")

# NOTE: The more complex functions in this package have a detailed monitoring
#       integrated which can be viewed by setting the argument 'monitor' to TRUE.

}
\keyword{internal}
