% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_norm_minmax.R
\name{minmax}
\alias{minmax}
\title{Min-max normalization}
\usage{
minmax()
}
\value{
returns an object of class \code{minmax}
}
\description{
Linearly scales numeric columns to the [0,1] range per column.
}
\details{
For each numeric column j, computes (x - min_j) / (max_j - min_j). Constant columns map to 0.

\eqn{minmax = (x-min(x))/(max(x)-min(x))}
}
\examples{
data(iris)
head(iris)

trans <- minmax()
trans <- fit(trans, iris)
tiris <- transform(trans, iris)
head(tiris)

itiris <- inverse_transform(trans, tiris)
head(itiris)
}
\references{
Han, J., Kamber, M., Pei, J. (2011). Data Mining: Concepts and Techniques. (Normalization section)
}
