% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guards.R
\name{.guard_ensure_levels}
\alias{.guard_ensure_levels}
\title{Ensure consistent categorical levels for guarded preprocessing}
\usage{
.guard_ensure_levels(df, levels_map = NULL, dummy_prefix = "__dummy__")
}
\arguments{
\item{df}{data.frame to normalize factor levels.}

\item{levels_map}{optional named list of factor levels learned from training data.}

\item{dummy_prefix}{prefix used when adding a dummy level to single-level factors.}
}
\value{
List with elements \code{data} (data.frame) and \code{levels} (named list of levels).
}
\description{
Converts character/logical columns to factors and aligns factor levels with
a training-time \code{levels_map}. Adds a dummy level when a column has only
one observed level so that downstream one-hot encoding retains a column.
}
\keyword{internal}
