% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SunCalcMeeus.r
\docType{package}
\name{SunCalcMeeus-package}
\alias{SunCalcMeeus}
\alias{SunCalcMeeus-package}
\title{SunCalcMeeus: Sun Position and Daylight Calculations}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Compute the position of the sun, and local solar time using Meeus' formulae. Compute day and/or night length using different twilight definitions or arbitrary sun elevation angles. This package is part of the 'r4photobiology' suite, Aphalo, P. J. (2015) \doi{10.19232/uv4pb.2015.1.14}. Algorithms from Meeus (1998, ISBN:0943396611).
}
\details{
Please see the vignette \emph{0: The R for
  Photobiology Suite} for a description of the suite.
}
\examples{
# daylength
sunrise_time(lubridate::today(tzone = "EET"), tz = "EET",
             geocode = data.frame(lat = 60, lon = 25),
             unit.out = "hour")
day_length(lubridate::today(tzone = "EET"), tz = "EET",
           geocode = data.frame(lat = 60, lon = 25),
           unit.out = "hour")
sun_angles(lubridate::now(tzone = "EET"), tz = "EET",
           geocode = data.frame(lat = 60, lon = 25))

}
\references{
Aphalo, Pedro J. (2015) The r4photobiology suite. \emph{UV4Plants Bulletin}, 2015:1,
21-29. \doi{10.19232/uv4pb.2015.1.14}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.r4photobiology.info/SunCalcMeeus/}
  \item \url{https://github.com/aphalo/SunCalcMeeus}
  \item Report bugs at \url{https://github.com/aphalo/SunCalcMeeus/issues}
}

}
\author{
\strong{Maintainer}: Pedro J. Aphalo \email{pedro.aphalo@helsinki.fi} (\href{https://orcid.org/0000-0003-3385-972X}{ORCID})

}
