% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weightedridge.reg.R
\name{Weightedridge.reg}
\alias{Weightedridge.reg}
\title{Weighted ridge regression}
\usage{
Weightedridge.reg(x, y, W)
}
\arguments{
\item{x}{Explanatory variables. A data.frame or matrix with observations in
rows and predictors in columns.}

\item{y}{Dependent variable. A numeric vector, data.frame, or matrix. For a
univariate response, this should be a length-\code{n} vector or an
\code{n x 1} matrix.}

\item{W}{Observation weights. Can be
\itemize{
  \item a numeric vector of length \code{n}, or
  \item a single-column data.frame of length \code{n}, or
  \item an \code{n x n} weight matrix.
}
If \code{W} is a vector or data.frame, the function converts it to
\code{diag(W)} internally.}
}
\value{
A \code{list} with the following components:
\describe{
  \item{cc}{Numeric scalar. The selected ridge parameter \code{k}.}
  \item{beta}{Numeric matrix (\code{p x 1}). Ridge regression coefficients on the standardized scale (no intercept).}
  \item{betaor}{Numeric matrix (\code{(p+1) x 1}). Coefficients on the original (unstandardized) scale, including the intercept in the first row.}
  \item{e}{Numeric matrix (\code{n x 1}). Residuals on the standardized scale (\code{yr - yhat}).}
  \item{ew}{Numeric matrix (\code{n x 1}). Weighted residuals (\code{W^(1/2) \%*\% e}).}
  \item{yhat}{Numeric matrix (\code{n x 1}). Fitted values on the standardized scale (\code{xr \%*\% beta}).}
  \item{yhatw}{Numeric matrix (\code{n x 1}). Fitted values in the weighted standardized space (\code{xrw \%*\% beta}).}
  \item{yhator}{Numeric matrix (\code{n x 1}). Fitted values on the original scale using \code{betaor}.}
  \item{MSE}{Numeric scalar. Mean squared error (MSE) computed from weighted residuals.}
  \item{F}{Numeric scalar. Overall model F statistic based on the weighted ANOVA decomposition.}
  \item{sig}{Numeric scalar. P-value associated with \code{F}.}
  \item{varbeta}{Numeric matrix (\code{p x p}). Estimated covariance matrix of \code{beta} on the standardized scale.}
  \item{stdbeta}{Numeric vector (length \code{p}). Standard errors of \code{beta}.}
  \item{R2}{Numeric scalar. Weighted coefficient of determination (R-squared).}
  \item{R2adj}{Numeric scalar. Adjusted weighted R-squared.}
  \item{anovatable}{A \code{data.frame}. ANOVA-style table with sums of squares, degrees of freedom, mean squares, \code{F}, and p-value.}
  \item{confint}{Numeric matrix (\code{2 x p}). Confidence intervals for \code{beta}; first row is lower, second row is upper.}
}
}
\description{
Fits a ridge regression model with observation-specific weights. The weights
can be supplied as a vector, data frame, or a square weight matrix. If a
vector or data frame is supplied, it is internally converted to a diagonal
weight matrix.
In the example below, the weight vector \code{W} is generated from a
Uniform(0, 1) distribution purely to illustrate how to call the function.
In practice, users should provide weights that reflect the structure of
their data.
}
\examples{
## Example: Weighted ridge regression using the bodyfat data from isdals
library(isdals)
data(bodyfat)

## Explanatory variables (x) and response (y)
x <- bodyfat[ , -1]   # all columns except the first: predictors
y <- bodyfat[ ,  1]   # first column: response (body fat percentage)

## Generate observation weights uniformly on [0, 1]

n <- nrow(x)
W <- runif(n, min = 0, max = 1)

## Fit the weighted ridge regression model
fit <- Weightedridge.reg(x, y, W)

## Inspect some key outputs
fit$beta        # coefficients in the standardized scale
fit$betaor      # coefficients in the original scale (including intercept)
fit$R2          # R-squared
fit$R2adj       # Adjusted R-squared
fit$anovatable  # ANOVA table

}
