% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_methods-PERFORMANCE.R
\docType{methods}
\name{sharpe}
\alias{sharpe}
\alias{sharpe,Strategy-method}
\title{Get Sharpe Ratio of Performance}
\usage{
sharpe(object, rf=0, of="portfolio"
     , from=NULL, until=NULL, which=NULL
     , scaling.periods=NULL, include.costs=TRUE
     , use.backtest=FALSE)

\S4method{sharpe}{Strategy}(object, rf = 0, of = c("portfolio", "assets"),
  from = NULL, until = NULL, which = NULL, scaling.periods = NULL,
  include.costs = TRUE, use.backtest = FALSE)
}
\arguments{
\item{object}{An object of class \code{Strategy}.}

\item{rf}{Risk free rate in decimal, e.g. \code{rf=0.01} equals \code{1 percent}.}

\item{of}{Sharpe ratio to be calculated for assets separately or the portfolio sharpe.}

\item{from}{The date in character format \code{"yyyy-MM-dd"} or as date-object from which performance shall be considered. If \code{NULL}, no restriction is made.}

\item{until}{The date in character format \code{"yyyy-MM-dd"} or as date-object until which performance shall be considered. If \code{NULL}, no restriction is made.}

\item{which}{Names or number of assets that should be included in calculation.}

\item{scaling.periods}{Vector with annualization factors for sharpe ratio calculation. Default is 252, 52, 12, 4, 1 for daily, weekly, monthly, quarterly and yearly data respectively.}

\item{include.costs}{If \code{FALSE}, the fixed and relative trading costs are NOT considered for performance calculation. Default value is \code{TRUE}. As default values for costs are \code{0}, this argument is obsolete if no costs are given.}

\item{use.backtest}{If \code{TRUE}, the performance of the backtesting output is considered for sharpe ratio calculation. If \code{FALSE}, the performance of the initial strategy execution are used.}
}
\description{
Get the sharpe ratio of the performance of an object of class \code{Strategy}.
}
\examples{
## Not run:

# MA(200)-Strategy
params <- list(k=200)
myStrat.MA <- Strategy(assets=assets, strat="MA", strat.params=params)

# Get sharpe of MA(200)-Strategy portfolio
sharpe(myStrat.MA, from="2015-01-01", until="2015-12-31")

# Get backtest annualized sharpe of MA(200)-Strategy (daily data = 252 trading days)
# sharpe(myStrat.MA, from="2015-01-01", until="2015-12-31", use.backtest=TRUE, scaling.periods=252)

## End(Not run)
}
