% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{skew.ged_fit}
\alias{skew.ged_fit}
\title{Fit Skewed Generalized Error Distribution to a vector of returns/stock prices.}
\usage{
skew.ged_fit(vec)
}
\arguments{
\item{vec}{A numeric vector of data.}
}
\value{
A list with the following elements:
\describe{
\item{params}{A numeric vector of length 4 containing the fitted SGED parameters: shape, scale, location, and skewness.}
\item{aic}{The Akaike Information Criterion (AIC) for the fitted model.}
\item{bic}{The Bayesian Information Criterion (BIC) for the fitted model.}
}
}
\description{
This function fits the Skewed Generalized Error Distribution to a given data vector using the \code{skew.ged_fit} function from
the \code{fGarch} package. It returns the estimated parameters along with the AIC and BIC values for the fitted
distribution.
}
\examples{

stock_prices <- c(10, 11, 12, 13, 14, 17, 18)
returns <- diff(log(stock_prices))
skew.ged_fit(returns)


}
\seealso{
\code{\link{norm_fit}}, \code{\link{t_fit}}, \code{\link{cauchy_fit}}, \code{\link{ghd_fit}}, \code{\link{hd_fit}},
\code{\link{sym.ghd_fit}}, \code{\link{sym.hd_fit}}, \code{\link{vg_fit}}, \code{\link{sym.vg_fit}},
\code{\link{nig_fit}}, \code{\link{ged_fit}}, \code{\link{skew.t_fit}},
\code{\link{skew.normal_fit}}
}
