% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gibbs_sampler.R
\name{spatopic_message}
\alias{spatopic_message}
\title{Format messages for SpaTopic package}
\usage{
spatopic_message(type = "INFO", message, timestamp = TRUE)
}
\arguments{
\item{type}{Character string indicating message type (e.g., "INFO", "WARNING", "ERROR", "PROGRESS")}

\item{message}{The message content to display}

\item{timestamp}{Logical; whether to include a timestamp in the message (default: TRUE)}
}
\value{
No return value, called for side effect of displaying a message
}
\description{
Creates consistently formatted messages for the SpaTopic package with 
timestamps and message type indicators. This function helps standardize
all output messages across the package. Error messages will stop execution.
}
\details{
This function prefixes messages with a timestamp and the SpaTopic tag,
creating a consistent message format throughout the package.
When type="ERROR", this will stop execution with stop().
When type="WARNING", this will use warning() for non-fatal warnings.
All other message types will use message() for informational output.
}
\examples{
\dontrun{
spatopic_message("INFO", "Starting analysis...")
spatopic_message("WARNING", "Parameter out of recommended range", timestamp = FALSE)
spatopic_message("ERROR", "Required input missing") # This will stop execution
spatopic_message("PROGRESS", "Processing complete")
}

}
