% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freundlichplot.R
\name{freundlichplot}
\alias{freundlichplot}
\title{Plots a Freundlich Isotherm using results from a static adsorption experiment}
\usage{
freundlichplot(Ce, Qe)
}
\arguments{
\item{Ce}{A numeric vector consisting of equilibrium concentration values}

\item{Qe}{A numeric vector consisting of quantities adsorbed at equilibrium}
}
\value{
The plot of log(Ce) against log(Qe) with the LSRL displayed
}
\description{
Plots a Freundlich Isotherm using results from a static adsorption experiment
}
\examples{
freundlichplot(c(1,2,3,4), c(1,2,3,4))
}
