% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STIR.R
\name{STIR}
\alias{STIR}
\title{Calculate STIR value}
\usage{
STIR(
  device = NA,
  speed = NA,
  speed_unit = "km/h",
  type_modifier = NA,
  depth = NA,
  depth_unit = "cm",
  area_disturbed = NA,
  original.STIR.value = FALSE
)
}
\arguments{
\item{device}{tillage or sowing implement or operation, must match predefined list,
or all necessary inputs (speed, type modidifier, depth, area_disturbed) must be provided}

\item{speed}{speed of the operation (km/h or mph)}

\item{speed_unit}{unit of the speed input, must be either NA, "km/h" or "mph".
Default value is "km/h"}

\item{type_modifier}{tillage operation type modifier, must be a value between 0 and 1}

\item{depth}{depth of the soil that is affected by the operation (cm or inch)}

\item{depth_unit}{unit of the depth input, must be either NA, "cm" or "inch".
Default value is "cm"}

\item{area_disturbed}{share of the surfave that is disturbed by the operation (0 to 1)}

\item{original.STIR.value}{logical value, if TRUE, the original STIR value of
the operation in the \code{STIR_value_LUT} (instead of the calculated STIR value) is returned.
Default value is FALSE}
}
\value{
STIR value of the operation
}
\description{
The function calculates the soil tillage intensity rating (STIR) value
of tillage and sowing operations.
By default, the \code{\link[=STIR]{STIR()}} function of \code{SoilManageR}
operates on SI units (cm and km/h) and not in imperial units (inch, mph)
as the original STIR equation \insertCite{RUSLE2}{SoilManageR}.
However, the user can specifiy that the input is in imperial units.
The function can process custom input, if no such input is provided
it assumes default values from the \code{STIR_value_LUT}.
}
\details{
The concept of the STIR value was developed within the
RUSLE2 framework by the \insertCite{RUSLE2;textual}{SoilManageR}.
The STIR equation is defined as

\deqn{STIR = (0.5 * speed) * (3.25 * type_{modifier}) * depth * area_{disturbed}}

where \eqn{speed} and \eqn{depth} are provided in mph and inches(!).
For the purpose of this function we assume that \verb{1 inch = 2.54 cm} and \verb{1 mph = 1.609 km/h}.
The tillage \eqn{type_{modifier}} is defined to be:
\itemize{
\item \code{1.00} for inversion operation
\item \code{0.80} for mixing and some inversion operations
\item \code{0.70} for mixing operations
\item \code{0.40} for lifting and fracturing operations
\item \code{0.15} for compression operations
}

In the \code{STIR_value_LUT} there are more than 400 operations,
incl. the original operations from the RUSLE2 software (as of 2023-02-24)
and operations defined by the SoilX project.

For further details on the STIR please consider the RUSLE2 website (https://fargo.nserl.purdue.edu/rusle2_dataweb/RUSLE2_Index.htm) or the description of the SoilManageR package
}
\examples{
#example without additional information
STIR("plough")

#example with additional information
STIR("rotary_harrow", depth = 15)

#custom example
STIR(speed = 10, type_modifier = 0.8, depth = 15, area_disturbed = 0.45)

#example that returns orginial STIR value
STIR("plough", original.STIR.value = TRUE)

#example that uses imperial units
STIR("plough", depth = 5, depth_unit = "inch", speed = 8, speed_unit = "mph")
}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item \code{\link[=tillage_intensity]{tillage_intensity()}} to calculate STIR values for management_df
\item \code{\link[=STIR_values_LUT]{STIR_values_LUT()}} for the reference data used by the \code{\link[=STIR]{STIR()}} function
}
}
