% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimTimeVar.R
\name{expand_subjects}
\alias{expand_subjects}
\title{Longitudinally expand a cluster}
\usage{
expand_subjects(mus3, n.OtherNorms, n.OtherBins, n.TBins, wcor, obs, parameters,
  zero = 1e-04)
}
\arguments{
\item{mus3}{A matrix of cluster means for each variable.}

\item{n.OtherNorms}{The number normal variables (not counting those
used for generating a time-varying binary variable).}

\item{n.OtherBins}{The number of static binary variables.}

\item{n.TBins}{The number of time-varying binary variables.}

\item{wcor}{The within-cluster correlation matrix.}

\item{obs}{The number of observations to generate per cluster.}

\item{parameters}{The parameters dataframe.}

\item{zero}{A small number just larger than 0.}
}
\description{
An internal function not intended for the user. Given a matrix of cluster means for each variable to
be simulated, "expands" them into time-varying observations.
}
\examples{
# subject means matrix (normally would be created internally within make_one_dataset)
mus3 = structure(c(1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1e-04, 1e-04, 0.886306145591761, 
1e-04, 1e-04, 1e-04, 1e-04, 0.875187001140343, 0.835990583043838, 
1e-04, 1e-04, 1e-04, 1e-04, 1e-04, 1e-04, 1e-04, 1e-04, 1e-04, 
1e-04, 1e-04, 69.7139993804559, 61.3137637852213, 68.3375516615242, 
57.7893277997516, 66.3744152975352, 63.7829561873355, 66.3864252981679, 
68.8513253460358, 67.4120718557, 67.8332265185068, 192.366192293195, 
128.048983102048, 171.550401133259, 120.348392753954, 158.840864356998, 
170.13484760994, 113.512220330821, 162.715528382999, 138.476877345895, 
159.841096973242, 115.026417822477, 109.527137142158, 117.087914485084, 
121.153861460319, 109.95973584141, 122.96960673409, 90.5100006255084, 
107.523229006601, 108.971677388246, 115.641818648526, -4.33184270434101, 
-5.45143483618415, -2.56331188314257, -1.38204452333064, -1.61744564863871, 
1.83911233741448, 2.0488338883998, -0.237095062415858, -5.47497506857878, 
-3.53078955238741), .Dim = c(10L, 7L))

expand_subjects( mus3 = mus3, n.OtherNorms = 4, n.OtherBins = 1, n.TBins = 2,
                wcor = wcor, obs = 3, parameters = complete_parameters(params, n=10) )
}
