% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{get_ns_spline}
\alias{get_ns_spline}
\title{Faster Pointwise Function than ns}
\usage{
get_ns_spline(knots, intercept = TRUE, do_log = TRUE)
}
\arguments{
\item{knots}{sorted numeric vector with boundary and interior knots.}

\item{intercept}{logical for whether to include an intercept.}

\item{do_log}{logical for whether to evaluate the spline at \code{log(x)}
or \code{x}.}
}
\description{
Creates a function which can evaluate a natural cubic spline like
\code{\link{ns}}.

The result may differ between different BLAS and LAPACK
implementations as the QR decomposition is not unique. However, the column space
of the returned matrix will always be the same regardless of the BLAS and LAPACK
implementation.
}
\examples{
# compare with splines
library(splines)
library(SimSurvNMarker)
xs <- seq(1, 5, length.out = 10L)
bks <- c(1, 5)
iks <- 2:4

# we get the same
if(require(Matrix)){
  r1 <- unclass(ns(xs, knots = iks, Boundary.knots = bks, intercept = TRUE))
  r2 <- get_ns_spline(knots = sort(c(iks, bks)), intercept = TRUE,
                      do_log = FALSE)(xs)

  cat("Rank is correct:      ", rankMatrix(cbind(r1, r2)) == NCOL(r1), "\n")

  r1 <- unclass(ns(log(xs), knots = log(iks), Boundary.knots = log(bks),
                   intercept = TRUE))
  r2 <- get_ns_spline(knots = log(sort(c(iks, bks))), intercept = TRUE,
                      do_log = TRUE)(xs)
  cat("Rank is correct (log):", rankMatrix(cbind(r1, r2)) == NCOL(r1), "\n")
}

# the latter is faster
system.time(
  replicate(100,
            ns(xs, knots = iks, Boundary.knots = bks, intercept = TRUE)))
system.time(
  replicate(100,
            get_ns_spline(knots = sort(c(iks, bks)), intercept = TRUE,
                          do_log = FALSE)(xs)))
func <- get_ns_spline(knots = sort(c(iks, bks)), intercept = TRUE,
                      do_log = FALSE)
system.time(replicate(100, func(xs)))

}
