% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{sc_cache}
\alias{sc_cache}
\alias{sc_cache_enable}
\alias{sc_cache_disable}
\alias{sc_cache_enabled}
\alias{sc_cache_dir}
\alias{sc_cache_files}
\alias{sc_cache_clear}
\title{Cache responses from the STATcube REST API}
\usage{
sc_cache_enable(verbose = TRUE)

sc_cache_disable()

sc_cache_enabled()

sc_cache_dir(dir = NULL)

sc_cache_files(x)

sc_cache_clear()
}
\arguments{
\item{verbose}{print instructions on how to set up caching persistently
via environment variables?}

\item{dir}{a cache directory}

\item{x}{an object of class \code{sc_table} or \code{sc_schema}}
}
\value{
\itemize{
\item for \code{\link[=sc_cache_enable]{sc_cache_enable()}}, \code{\link[=sc_cache_dir]{sc_cache_dir()}}: the path to the cache-directory
\item for \code{\link[=sc_cache_disable]{sc_cache_disable()}}: \code{TRUE}
\item for \code{\link[=sc_cache_enabled]{sc_cache_enabled()}}: \code{TRUE} if caching is enabled, \code{FALSE} otherwise
\item for \code{\link[=sc_cache_files]{sc_cache_files()}}: the content of the cache associated with a file
\item for \code{\link[=sc_cache_clear]{sc_cache_clear()}}: \code{NULL}
}
}
\description{
Functions to cache requested resources in the directory \verb{~/.STATcubeR_cache}
and reuse them in calls to \code{\link[=sc_table]{sc_table()}}, \code{\link[=sc_table_custom]{sc_table_custom()}} \code{\link[=sc_schema]{sc_schema()}} and so forth.
These functions are designed for testing and documentation and should not be
regarded as part of the STATcubeR interface. The caching logic is likely to
change in the future in which case \code{\link[=sc_cache_clear]{sc_cache_clear()}} is required to purge
old cache entries.
}
\details{
Caching can be set up using environment variables. To set up a persistent cache
for both Open Data and the REST API, the following lines in \code{.Renviron} can
be used.
The paths in this example are only applicable for UNIX-based operating systems.

\if{html}{\out{<div class="sourceCode sh">}}\preformatted{STATCUBE_KEY_EXT   = YOUR_API_KEY_GOES_HERE
STATCUBE_CACHE     = TRUE
OD_CACHE_DIR       = "~/.cache/STATcubeR/open_data/"
STATCUBE_CACHE_DIR = "~/.cache/STATcubeR/api/"
}\if{html}{\out{</div>}}

If caching is enabled, there is no check to verify if the
resources are unchanged in the server.
Caching is not implemented for the
endpoints \code{\link[=sc_info]{sc_info()}} and \code{\link[=sc_rate_limit_table]{sc_rate_limit_table()}}.
}
\section{Functions}{
\itemize{
\item \code{sc_cache_enable()}: enables caching for the current R session

\item \code{sc_cache_disable()}: disables caching for the current R session
sc_cache_disable()

\item \code{sc_cache_enabled()}: informs whether the cache is currently enabled

\item \code{sc_cache_dir()}: get/set the directory used for caching

\item \code{sc_cache_files()}: get the cache file associated with an object

\item \code{sc_cache_clear()}: removes all files from the cache

}}
