% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R, R/predict_glm.R
\name{predict.SSN2}
\alias{predict.SSN2}
\alias{predict.ssn_lm}
\alias{predict.ssn_glm}
\title{Model predictions (Kriging)}
\usage{
\method{predict}{ssn_lm}(
  object,
  newdata,
  se.fit = FALSE,
  scale = NULL,
  df = Inf,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  type = c("response", "terms"),
  block = FALSE,
  local,
  terms = NULL,
  na.action = na.fail,
  ...
)

\method{predict}{ssn_glm}(
  object,
  newdata,
  type = c("link", "response", "terms"),
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  dispersion = NULL,
  terms = NULL,
  local,
  var_correct = TRUE,
  newdata_size,
  na.action = na.fail,
  ...
)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{newdata}{A character vector that indicates the name of the prediction data set
for which predictions are desired (accessible via \code{object$ssn.object$preds}).
Note that the prediction data must be in the original SSN object used to fit the model.
If \code{newdata} is omitted, predictions
for all prediction data sets are returned. Note that the name \code{".missing"}
indicates the prediction data set that contains the missing observations in the data used
to fit the model.}

\item{se.fit}{A logical indicating if standard errors are returned.
The default is \code{FALSE}.}

\item{scale}{A numeric constant by which to scale the regular standard errors and intervals.
Similar to but slightly different than \code{scale} for \code{\link[stats:predict.lm]{stats::predict.lm()}}, because
predictions form a spatial model may have different residual variances for each
observation in \code{newdata}. The default is \code{NULL}, which returns
the regular standard errors and intervals.}

\item{df}{Degrees of freedom to use for confidence or prediction intervals
(ignored if \code{scale} is not specified). The default is \code{Inf}.}

\item{interval}{Type of interval calculation. The default is \code{"none"}.
Other options are \code{"confidence"} (for confidence intervals) and
\code{"prediction"} (for prediction intervals).}

\item{level}{Tolerance/confidence level. The default is \code{0.95}.}

\item{type}{The scale (\code{response} or \code{link}) of predictions obtained
using \code{ssn_glm} objects.}

\item{block}{A logical indicating whether a block prediction over the entire
region in \code{newdata} should be returned. The default is \code{FALSE}, which returns point
predictions for each location in \code{newdata}. Currently only available for
model fit using \code{ssn_lm()} or models fit using \code{ssn_glm()} where
\code{family} is \code{"gaussian"}.}

\item{local}{A optional logical or list controlling the big data approximation. If omitted, \code{local}
is set to \code{TRUE} or \code{FALSE} based on the observed data sample size (i.e., sample size of the fitted
model object) -- if the sample size exceeds 10,000, \code{local} is
set to \code{TRUE}, otherwise it is set to \code{FALSE}. This default behavior
occurs because main computational
burden of the big data approximation depends almost exclusively on the
observed data sample size, not the number of predictions desired
(which we feel is not intuitive at first glance).
If \code{local} is \code{FALSE}, no big data approximation
is implemented. If a list is provided, the following arguments detail the big
data approximation:
\itemize{
\item \code{method}: The big data approximation method. If \code{method = "all"},
all observations are used and \code{size} is ignored.
If \code{method = "covariance"}, the \code{size} data observations
having the average highest covariance with the prediction locations are used.
The default
is \code{"covariance"}. Only used with models fit using \code{\link[=ssn_lm]{ssn_lm()}}.
\item \code{size}: The number of data observations to use when \code{method}
is \code{"distance"} or \code{"covariance"}. The default is 4000. Only used
with models fit using \code{\link[=ssn_lm]{ssn_lm()}}.
\item \code{parallel}: If \code{TRUE}, parallel processing via the
parallel package is automatically used. This can significantly speed
up computations even when \code{method = "all"} (i.e., no big data
approximation is used), as predictions
are spread out over multiple cores. The default is \code{FALSE}.
\item \code{ncores}: If \code{parallel = TRUE}, the number of cores to
parallelize over. The default is the number of available cores on your machine.
}
When \code{local} is a list, at least one list element must be provided to
initialize default arguments for the other list elements.
If \code{local} is \code{TRUE}, defaults for \code{local} are chosen such
that \code{local} is transformed into
\code{list(size = 4000, method = "covariance", parallel = FALSE)}.}

\item{terms}{If \code{type} is \code{"terms"}, the type of terms to be returned,
specified via either numeric position or name. The default is all terms are included.}

\item{na.action}{Missing (\code{NA}) values in \code{newdata} will return an error and should
be removed before proceeding.}

\item{...}{Other arguments. Not used (needed for generic consistency).}

\item{dispersion}{The dispersion of assumed when computing the prediction standard errors
for \code{ssn_glm()} model objects when \code{family}
is \code{"nbinomial"}, \code{"beta"}, \code{"Gamma"}, or \code{"inverse.gaussian"}.
If omitted, the model object dispersion parameter is used.}

\item{var_correct}{A logical indicating whether to return the corrected prediction
variances when predicting via models fit using \code{ssn_glm}. The default is
\code{TRUE}.}

\item{newdata_size}{The \code{size} value for each observation in \code{newdata}
used when predicting for the binomial family.}
}
\value{
If \code{se.fit} is \code{FALSE}, \code{predict.ssn()} returns
a vector of predictions or a matrix of predictions with column names
\code{fit}, \code{lwr}, and \code{upr} if \code{interval} is \code{"confidence"}
or \code{"prediction"}. If \code{se.fit} is \code{TRUE}, a list with the following components is returned:
\itemize{
\item \code{fit}: vector or matrix as above
\item \code{se.fit:} standard error of each fit
}
}
\description{
Predicted values and intervals based on a fitted model object.
}
\details{
The (empirical) best linear unbiased predictions (i.e., Kriging
predictions) at each site are returned when \code{interval} is \code{"none"}
or \code{"prediction"} alongside standard errors. Prediction intervals
are also returned if \code{interval} is \code{"prediction"}. When
\code{interval} is \code{"confidence"}, the estimated mean is returned
alongside standard errors and confidence intervals for the mean.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, predpts = "pred1km", overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
predict(ssn_mod, "pred1km")
}
