% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{anova.SSN2}
\alias{anova.SSN2}
\alias{anova.ssn_lm}
\alias{anova.ssn_glm}
\alias{tidy.anova.ssn_lm}
\alias{tidy.anova.ssn_glm}
\title{Compute analysis of variance and likelihood ratio tests of fitted model objects}
\usage{
\method{anova}{ssn_lm}(object, ..., test = TRUE, Terms, L)

\method{anova}{ssn_glm}(object, ..., test = TRUE, Terms, L)

\method{tidy}{anova.ssn_lm}(x, ...)

\method{tidy}{anova.ssn_glm}(x, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{...}{An additional fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}
(for \code{anova()}).}

\item{test}{A logical value indicating whether p-values from asymptotic Chi-squared
hypothesis tests should be returned. Defaults to \code{TRUE}.}

\item{Terms}{An optional character or integer vector that specifies terms in the model
used to jointly compute test statistics and p-values (if \code{test = TRUE})
against a null hypothesis of zero. \code{Terms} is only used when a single fitted model
object is passed to the function. If \code{Terms} is a character vector, it
should contain the names of the fixed effect terms. If \code{Terms} is an integer
vector, it should correspond to the order (starting at one) of the names
of the fixed effect terms. The easiest way to obtain the names of
all possible terms is to run \code{tidy(anova(object))$effects} (the
integer representation matches the positions of this vector).}

\item{L}{An optional numeric matrix or list specifying linear combinations
of the coefficients in the model used to compute test statistics
and p-values (if \code{test = TRUE}) for coefficient constraints corresponding to a null
hypothesis of zero. \code{L} is only used when a single fitted model
object is passed to the function. If \code{L} is a numeric matrix, its rows
indicate coefficient constraints and its columns
represent coefficients. Then a single hypothesis test is conducted
against a null hypothesis of zero.
If \code{L} is a list, each list element is a numeric matrix specified as above.
Then separate hypothesis tests are conducted. The easiest
way to obtain all possible coefficients is to run \code{tidy(object)$term}.}

\item{x}{An object from \code{anova(object)}.}
}
\value{
When one fitted model object is present, \code{anova()}
returns a data frame with degrees of
freedom (\code{Df}), test statistics (\code{Chi2}), and p-values
(\code{Pr(>Chi2)} if \code{test = TRUE}) corresponding
to asymptotic Chi-squared hypothesis tests for each model term.

When two fitted model objects are present, \code{anova()} returns a data frame
with the difference in degrees of freedom between the full and reduced model (\code{Df}), a test
statistic (\code{Chi2}), and a p-value corresponding to the likelihood ratio test
(\code{Pr(>Chi2)} if \code{test = TRUE}).

Whether one or two fitted model objects are provided,
\code{tidy()} can be used
to obtain tidy tibbles of the \code{anova(object)} output.
}
\description{
Compute analysis of variance tables for a fitted model object or
a likelihood ratio test for two fitted model objects.
}
\details{
When one fitted model object is present, \code{anova()}
performs a general linear hypothesis test corresponding to some hypothesis
specified by a matrix of constraints. If \code{Terms} and \code{L} are not specified,
each model term is tested against zero (which correspond to type III or marginal
hypothesis tests from classical ANOVA). If \code{Terms} is specified and \code{L}
is not specified, all terms are tested jointly against zero. When \code{L} is
specified, the linear combinations of terms specified by \code{L} are jointly
tested against zero.

When two fitted model objects are present, one must be a "reduced"
model nested in a "full" model. Then \code{anova()} performs a likelihood ratio test.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
anova(ssn_mod)
tidy(anova(ssn_mod))
}
