% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GP_SSM.R
\name{new.distance}
\alias{new.distance}
\title{Compute the distance matrix of an SSM design.}
\usage{
new.distance(type = "distance", ssm, line.grid = 100)
}
\arguments{
\item{type}{(optional) Character. Specifies the distance measure used.
Acceptable values are "distance", "line", "product", "area", "proddiff",
"smoothdiff".}

\item{ssm}{An SSM object.}

\item{line.grid}{(optional). An integer. Specifies the number of points used
in the computation of the distance matrix when \code{type = "line"}.}
}
\value{
A matrix.
}
\description{
Computes the distance matrix associated with the design held in the
\code{design} slot of an SSM object. Used in the construction of the
metamodel error estimating Gaussian process.
}
\details{
Implemented types of distance measure are:
\itemize{
  \item{\code{"distance"}}{ Standard Euclidean distance.}
  \item{\code{"line"}}{ The line integral of the smoothness between design
    points. This is not implemented for data where \code{d} > 1.}
  \item{\code{"product"}}{ The product of the Euclidean distance and the
    local smoothness at both points.}
  \item{\code{"area"}}{ The sum of the local smoothness at the points
    multiplied by the Euclidean distance.}
  \item{\code{"proddiff"}}{ Multiplies the difference in local smoothness
    between points by the Euclidean distance.}
  \item{\code{"smoothdiff"}}{ The difference between the local smoothness of
    points.}
}
All measures other than \code{"distance"} are experimental and should be
used with caution.
}
\keyword{internal}

