% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRSplineMed.R
\name{SRSplineMed}
\alias{SRSplineMed}
\title{Calculate the CDE, NDE and NIE.}
\usage{
SRSplineMed(
  data,
  nBasis,
  exposure,
  mediator,
  outcome,
  confounderVec,
  shapeExp,
  shapeNonExp,
  mValue,
  varAsymp = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{nBasis}{The number of bases.}

\item{exposure}{The name of the exposure (must be a binary variable).}

\item{mediator}{The name of the mediator (must be a continuous variable).}

\item{outcome}{The name of the outcome (must be a continuous variable).}

\item{confounderVec}{The name vector of the confounders.}

\item{shapeExp}{The shape of mediator in exposure group ("increasing", "decreasing", "convex", or "concave").}

\item{shapeNonExp}{The shape of mediator in non-exposure group ("increasing", "decreasing", "convex", or "concave").}

\item{mValue}{The controlled mediator value for CDE estimation.}

\item{varAsymp}{Whether to output the asymptotic variance (T/F)}
}
\value{
A list of exposure-outcome model, exposure-mediator model, knot sequence, coefficient vector of exposure spline, coefficient vector of non-exposure spline, residuals, sds and coefficients, CDE, NDE and NIE and their asymptotic variances.
}
\description{
Calculate the CDE, NDE and NIE.
}
\examples{
medModel <- SRSplineMed(data = data.sim.med, nBasis = 5,
                        exposure = "pesticide1", mediator = "hormone", outcome = "ySim",
                        confounderVec = c("age", "invwt", "race2", "race3", "race4", "race5",
                                          "season2", "season3", "season4", "smoking1", "ovum1",
                                          "diabetes1"),
                        shapeExp = "concave", shapeNonExp = "increasing", mValue = 0.15,
                        varAsymp = TRUE)
medModel

}
