#' Dog measurements
#'
#' Measurements of Phu Quoc Ridgeback dogs.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 30 rows (one per dog) and 4 columns:
#' \describe{
#'   \item{BL}{Body length, in cm}
#'   \item{BH}{Body height, in cm}
#'   \item{Chest}{Chest measurement, in cm}
#'   \item{Waist}{Waist measurement, in cm}
#' }
#' @source 
#' Quan, Quoc-Dang, Hoang-Dung Tran, and Anh-Dung Chung. 2017. 
#' The Relation of Body Score (Body Height/Body Length) and 
#' Haplotype E on Phu Quoc Ridgeback Dogs (Canis Familiaris).
#' \emph{Journal of Entomology and Zoology Studies} \bold{5}: 388--94
#' 
#' @usage 
#' data(Dogs)
#' 
#' @examples
#' plot(BL ~ BH, data = Dogs, xlab = "Height (cm)", ylab = "Length (cm)")
#' 

"Dogs"
